<?php
include("templates/headers/inc.php");	

// Initialize FB SDK
$fb = new \Facebook\Facebook([
	'app_id' => FB_APP_ID,
	'app_secret' => FB_APP_SECRET,
	'default_graph_version' => 'v2.3'
]);	

$helper = $fb->getRedirectLoginHelper();

try {
	$accessToken = $helper->getAccessToken();
} catch(Facebook\Exceptions\FacebookResponseException $e) {
	// When Graph returns an error
	echo 'Error while logging you in... ' . $e->getMessage();
	exit;
} catch(Facebook\Exceptions\FacebookSDKException $e) {
	// When validation fails or other local issues
	echo 'Error while logging you in... ' . $e->getMessage();
	exit;
}

if (! isset($accessToken)) {
	
	if ($helper->getError()) {
		header('HTTP/1.0 401 Unauthorized');
		echo "Error: " . $helper->getError() . "\n";
		echo "Error Code: " . $helper->getErrorCode() . "\n";
		echo "Error Reason: " . $helper->getErrorReason() . "\n";
		echo "Error Description: " . $helper->getErrorDescription() . "\n";
		exit;
	} else {
		header('HTTP/1.0 400 Bad Request');
		echo 'Bad request';
	}
	
	exit;
}

// The OAuth 2.0 client handler helps us manage access tokens
$oAuth2Client = $fb->getOAuth2Client();

// Get the access token metadata from /debug_token
$tokenMetadata = $oAuth2Client->debugToken($accessToken);

$tokenMetadata->validateAppId(FB_APP_ID);
$tokenMetadata->validateExpiration();

if (! $accessToken->isLongLived()) {
	// Exchanges a short-lived access token for a long-lived one
	try {
		$accessToken = $oAuth2Client->getLongLivedAccessToken($accessToken);
	} catch (Facebook\Exceptions\FacebookSDKException $e) {
		echo "<p>Error getting long-lived access token: " . $e->getMessage() . "</p>\n\n";
		exit;
	}

	echo '<h3>Long-lived</h3>';
	var_dump($accessToken->getValue());
}

// Save access token
$_SESSION['FB_TOKEN'] = (string) $accessToken;

try {
	
	// Returns a `Facebook\FacebookResponse` object
	$response = $fb->get('/me?fields=id,name,email', $accessToken);

	// Get user
	$user = $response->getGraphUser();
	
	// Get user's infos
	$fb_id 		= $user["id"];
	$fullname 	= $user["name"];
	
	if(isset($user["email"])) {
		$email 		= $user["email"];
	} else {
		$email		= "";
	}

	$profile_picture = "http://graph.facebook.com/" . $fb_id . "/picture?type=large";
	
	// Check if user exists...
	$user_sql = $dbh->prepare("	SELECT id, fullname, email, profile_picture, rank
								FROM user
								WHERE fb_id = :fb_id
								");
						
	$user_sql->bindParam(':fb_id', $fb_id);
	$user_sql->execute();
	
	$new_user = false;
	
	// User doesn't exist, we create it !
	if($user_sql->rowCount() == 0) {
		
		// Count total users in the DB
		$user_total_sql = $dbh->prepare("	SELECT id
											FROM user
											");
		$user_total_sql->execute();
		
		$total_users = $user_total_sql->rowCount();
		
		if($total_users == 0) {
			$user_rank = 1;
		} else {
			$user_rank = 0;
		}
		
		$stmt = $dbh->prepare("	INSERT INTO user
								SET 
								fb_id = :fb_id,
								fullname = :fullname,
								email = :email,
								profile_picture = :profile_picture,
								created_at = UTC_TIMESTAMP(),
								status = 1,
								origin = 'home',
								rank = :user_rank
								");
							
		$stmt->bindParam(':fb_id', $fb_id);
		$stmt->bindParam(':fullname', $fullname);
		$stmt->bindParam(':email', $email);
		$stmt->bindParam(':user_rank', $user_rank);
		$stmt->bindParam(':profile_picture', $profile_picture);
		
		$stmt->execute();
		
		// Get user's id
		$user_id = $dbh->lastInsertId();
		
		// Set the redirect action
		$action = "register";
		
		// It's a new user's creeation
		$new_user = true;
		
	} 
	// User logs in !
	else {
		
		$user_i = $user_sql->fetch();
		
		// Update the user's infos
		$stmt = $dbh->prepare("	UPDATE user
								SET 
								fullname = :fullname,
								email = :email,
								profile_picture = :profile_picture
								WHERE fb_id = :fb_id
								");
							
		$stmt->bindParam(':fb_id', $fb_id);
		$stmt->bindParam(':fullname', $fullname);
		$stmt->bindParam(':email', $email);
		$stmt->bindParam(':profile_picture', $profile_picture);
		
		$stmt->execute();
		
		// Get user's id
		$user_id = $user_i["id"];
		
		// Set the redirect action
		$action = "login";
		
		// Get user's rank
		$user_rank = $user_i["rank"];
		
	}
	
	// Open session
	$_SESSION["USER_ID"] = $user_id;
	$_SESSION["EMAIL"] = $email;
	$_SESSION["FULL_NAME"] = $fullname;
	$_SESSION["PROFILE_PICTURE"] = $profile_picture;
	$_SESSION["RANK"] = $user_rank;
		
	if($_COOKIE && isset($_COOKIE["redirect_quiz_id"])) {
		
		$quiz_id = $_COOKIE["redirect_quiz_id"];
		
		// Delete the cookie...
		unset($_COOKIE['redirect_quiz_id']);
		setcookie('redirect_quiz_id', null, -1, '/');
		
		if($new_user) {
			$stmt = $dbh->prepare("	UPDATE user
									SET 
									origin = 'quiz'
									WHERE id = :user_id
									");
								
			$stmt->bindParam(':user_id', $user_id);
			$stmt->execute();
		}
		
		// Redirect..
		header("Location: " . URL . "/quiz.php?id=" . $quiz_id);
		
	} else {
		
		if($new_user) {
			$stmt = $dbh->prepare("	UPDATE user
									SET 
									origin = 'home'
									WHERE id = :user_id
									");
								
			$stmt->bindParam(':user_id', $user_id);
			$stmt->execute();
		
			// Redirects
			header("Location: create-quiz.php?action=$action");
		} else {
			// Redirects
			header("Location: home.php?action=$action");
		}
		
	}
	
	
} catch(Facebook\Exceptions\FacebookResponseException $e) {
	
	echo 'Graph returned an error: ' . $e->getMessage();
	exit;
	
} catch(Facebook\Exceptions\FacebookSDKException $e) {
	
	echo 'Facebook SDK returned an error: ' . $e->getMessage();
	exit;
	
}
?>